#include "DTreeView.h"

namespace DWL {

    DTreeView_Nodo::DTreeView_Nodo(DTreeView *TV, HTREEITEM nNodo) { 
		_TV = TV; 
		_Nodo = nNodo;
		_ColorFondo = _TV->ColorFondo();
		_ColorTexto = _TV->ColorTexto();
		_Fuente = TV->_Fuente;
	};


	DTreeView_Nodo::DTreeView_Nodo(DTreeView *TV, HTREEITEM nNodo, COLORREF nColorFondo, COLORREF nColorTexto) { 
		_TV = TV;
		_Nodo = nNodo; 
		_ColorFondo = nColorFondo; 
		_ColorTexto = nColorTexto; 
		_Fuente = TV->_Fuente;
	};



	void DTreeView_Nodo::HacerVisible(void) { 
		TreeView_EnsureVisible(_TV->_hWnd, _Nodo);
	};


	void DTreeView_Nodo::AsignarTexto(DString &nTexto) {
		TCHAR Tmp[256];
		DWLStrCopy(Tmp, 256, nTexto());
		TVITEM TvItem;
		TvItem.mask = TVIF_HANDLE | TVIF_TEXT; 
		TvItem.pszText = Tmp;
		TvItem.cchTextMax = static_cast<int>(DWLStrLen(Tmp));
		TvItem.hItem = _Nodo;
		TreeView_SetItem(_TV->_hWnd, &TvItem);
	};


	void DTreeView_Nodo::ObtenerTexto(DString &nTexto) { 
		TCHAR Tmp[256];
		TVITEM TvItem;
		TvItem.mask = TVIF_HANDLE | TVIF_TEXT; 
		TvItem.pszText = Tmp;
		TvItem.cchTextMax = 256;
		TvItem.hItem = _Nodo;
		TreeView_GetItem(_TV->_hWnd, &TvItem);
		nTexto = Tmp;
	};


	void DTreeView_Nodo::Icono(const int nIcono) {
		TVITEM TvItem;
		TvItem.mask = TVIF_HANDLE | TVIF_IMAGE; 
		TvItem.iImage = nIcono;
		TvItem.hItem = _Nodo; 
		TreeView_SetItem(_TV->_hWnd, &TvItem); 
	};


	const int DTreeView_Nodo::Icono(void) { 
		TVITEM TvItem; 
		TvItem.mask = TVIF_HANDLE | TVIF_IMAGE ; 
		TvItem.hItem = _Nodo; 
		TreeView_GetItem(_TV->_hWnd, &TvItem); 
		return TvItem.iImage; 
	};


	void DTreeView_Nodo::IconoSeleccionado(const int nIcono) { 
		TVITEM TvItem; 
		TvItem.mask = TVIF_HANDLE | TVIF_SELECTEDIMAGE;
		TvItem.iSelectedImage = nIcono;
		TvItem.hItem = _Nodo;
		TreeView_SetItem(_TV->_hWnd, &TvItem); 
	};


	const int DTreeView_Nodo::IconoSeleccionado(void) { 
		TVITEM TvItem; 
		TvItem.mask = TVIF_HANDLE | TVIF_SELECTEDIMAGE;
		TvItem.hItem = _Nodo;
		TreeView_GetItem(_TV->_hWnd, &TvItem);
		return TvItem.iSelectedImage;
	};


	DTreeView_Nodo *DTreeView_Nodo::NodoHijo(void) {
		return _TV->BuscarNodo(TreeView_GetChild(_TV->_hWnd, _Nodo));
	};


	DTreeView_Nodo *DTreeView_Nodo::NodoPadre(void) { 
		return _TV->BuscarNodo(TreeView_GetParent(_TV->_hWnd, _Nodo));
	};

	DTreeView_Nodo *DTreeView_Nodo::NodoSiguiente(void) { 
		return _TV->BuscarNodo(TreeView_GetNextItem(_TV->_hWnd, _Nodo, TVGN_NEXT)); 
	};


	DTreeView_Nodo *DTreeView_Nodo::NodoAnterior(void) {
		return _TV->BuscarNodo(TreeView_GetNextItem(_TV->_hWnd, _Nodo, TVGN_PREVIOUS)); 
	};


	HTREEITEM DTreeView_Nodo::Hijo(void) { 
		return TreeView_GetChild(_TV->_hWnd, _Nodo); 
	};


	HTREEITEM DTreeView_Nodo::Padre(void) { 
		return TreeView_GetParent(_TV->_hWnd, _Nodo); 
	};


	HTREEITEM DTreeView_Nodo::Siguiente(void) { 
		return TreeView_GetNextItem(_TV->_hWnd, _Nodo, TVGN_NEXT); 
	};


	HTREEITEM DTreeView_Nodo::Anterior(void) {
		return TreeView_GetNextItem(_TV->_hWnd, _Nodo, TVGN_PREVIOUS); 
	};


	void DTreeView_Nodo::Seleccionar(void) { 
		TreeView_SelectItem(_TV->_hWnd, _Nodo);
	};


	void DTreeView_Nodo::_AsignarBase(DTreeView *TV, HTREEITEM nNodo, COLORREF nColorFondo, COLORREF nColorTexto) { 
		_TV = TV; 
		_Nodo = nNodo;
		_ColorFondo = nColorFondo; 
		_ColorTexto = nColorTexto;
		_Fuente = TV->_Fuente; 
	};


	void DTreeView_Nodo::_AsignarBase(DTreeView *TV, HTREEITEM nNodo) { 
		_TV = TV; 
		_Nodo = nNodo; 
		_ColorFondo = _TV->ColorFondo();
		_ColorTexto = _TV->ColorTexto();
		_Fuente = TV->_Fuente; 
	};

};